import React from "react";
import DescParseHTML from "./DescParseHTML";
import { bannerStyle } from "./homeBannerStyle";
import * as Animatable from "react-native-animatable";
import { View, Text, StyleSheet, I18nManager } from "react-native";
import ProgressiveImage from "../../../src/components/ProgressiveImage";
import dpr from "../../Utilities/CustomStyleAttribute/dpr";

const BannerRenderItem = ({ item }) => {
    return (
        <View style={bannerStyle.banner}>
            <ProgressiveImage
                style={[bannerStyle.image, I18nManager.isRTL && {transform: [{ scaleX: -1 }] }]}
                source={{
                    uri: item?.image,
                }}
            />
            <View style={bannerStyle.content}>
                <Animatable.View animation={item?.title_animation}>
                    <Text
                        style={bannerStyle.title(item?.title_font_color)}
                    >
                        {item?.title_text}
                    </Text>
                </Animatable.View>
                <Animatable.View animation={item?.sub_title_animation}>
                    <Text
                        style={bannerStyle.subTitle(item?.sub_title_font_color)}
                    >
                        {item?.sub_title_text}
                    </Text>
                </Animatable.View>
                <Animatable.View animation={item?.description_title_animation}>
                    <View style={bannerStyle.description}>
                        <Description
                            description={item?.description_title_text}
                            color={item?.description_title_font_color}
                        />
                    </View>
                </Animatable.View>
            </View>
        </View>
    );
};

export default BannerRenderItem;

const Description = ({ description, color }) => {
    return (
        <Text style={itemDescriptionStyle.text(color)}>
            <DescParseHTML description={description} />
        </Text>
    );
};

const itemDescriptionStyle = StyleSheet.create({
    text: (color) => ({
        lineHeight: dpr(15),
        fontFamily: "DMSans_400Regular",
        fontSize: dpr(12),
        color: color
    }),
});
